///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabGeneralDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND CompanyName_hWnd     = NULL;
    static HWND CompanyPwd_hWnd      = NULL;
    static HWND ConnectInterval_hWnd = NULL;
    static HWND PortalSvr_hWnd       = NULL;
    static HWND PortalSvrPort_hWnd   = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        char Temp[32];

        CompanyName_hWnd     = GetDlgItem(xHandle, IDC_COMPANYNAME);
        CompanyPwd_hWnd      = GetDlgItem(xHandle, IDC_COMPANYPWD);

        ConnectInterval_hWnd = GetDlgItem(xHandle, IDC_CONNECTINTERVAL);
        PortalSvr_hWnd       = GetDlgItem(xHandle, IDC_PORTALSVR);
        PortalSvrPort_hWnd   = GetDlgItem(xHandle, IDC_PORTALSVRPORT);

        Set_Text(CompanyName_hWnd, gsCompanyName);
        Set_Text(CompanyPwd_hWnd, gsCompanyPassword);

        LongCharEx(glConnectInterval, Temp);
        Set_Text(ConnectInterval_hWnd, Temp);
        Set_Text(PortalSvr_hWnd, gsWPServer);
        LongCharEx(glConnectPort, Temp);
        Set_Text(PortalSvrPort_hWnd, Temp);

        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsCompanyName[64 + 1];
            int liCompanyNameLen = Get_TextEx(CompanyName_hWnd, lsCompanyName, 64);
            if(liCompanyNameLen == 0 || liCompanyNameLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company name. Between 1 and 64 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsCompanyPwd[64 + 1];
            int liCompanyPwdLen = Get_TextEx(CompanyPwd_hWnd, lsCompanyPwd, 64);
            if(liCompanyPwdLen == 0 || liCompanyPwdLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company password. Between 1 and 64 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            DWORD llConnectInterval = Get_Long(ConnectInterval_hWnd);
            if(llConnectInterval < 10 || llConnectInterval > 86400)
            {
                MessageBox(xHandle, "You must enter a valid connection interval. Between 1 and 86,400.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsPortalSvr[255 + 1];
            int liPortalSvrLen = Get_TextEx(PortalSvr_hWnd, lsPortalSvr, 255);
            if(liPortalSvrLen == 0 || liPortalSvrLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid portal server name. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            DWORD llConnectPort = Get_Long(PortalSvrPort_hWnd);
            if(llConnectPort == 0 || llConnectPort > 65535)
            {
                MessageBox(xHandle, "You must enter a valid portal server port. Between 1 and 65,535.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy(gsCompanyName, lsCompanyName);
            strcpy(gsCompanyPassword, lsCompanyPwd);
            strcpy(gsWPServer, lsPortalSvr);

            glConnectPort     = llConnectPort;
            glConnectInterval = llConnectInterval;

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

